/******************************************************************************/
/****              Generated by IBExpert 14/08/2023 17:36:37               ****/
/******************************************************************************/

/******************************************************************************/
/****     Following SET SQL DIALECT is just for the Database Comparer      ****/
/******************************************************************************/


/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/


CREATE GENERATOR GEN_CENTRAL_SERVICOS_NOTIFIC_ID;

CREATE TABLE CENTRAL_SERVICOS_NOTIFICACOES (
    CODIGO                  DOM_CODIGO NOT NULL /* DOM_CODIGO = INTEGER */,
    DESCRICAO               DOM_TEXTO_250 /* DOM_TEXTO_250 = VARCHAR(250) */,
    FINALIZADO              DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    COD_USUARIO_FINALIZADO  DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    COD_USUARIO             DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    DATA_INC                DOM_DATA_HORA /* DOM_DATA_HORA = DATE */
);



/******************************************************************************/
/****                             Primary keys                             ****/
/******************************************************************************/

ALTER TABLE CENTRAL_SERVICOS_NOTIFICACOES ADD CONSTRAINT PK_CENTRAL_SERVICOS_NOTIFICACOE PRIMARY KEY (CODIGO);


/******************************************************************************/
/****                               Indices                                ****/
/******************************************************************************/

CREATE INDEX CENTRAL_SERVICOS_NOTIFICAC_IDX1 ON CENTRAL_SERVICOS_NOTIFICACOES (DESCRICAO);
CREATE INDEX CENTRAL_SERVICOS_NOTIFICAC_IDX2 ON CENTRAL_SERVICOS_NOTIFICACOES (FINALIZADO);


/******************************************************************************/
/****                               Triggers                               ****/
/******************************************************************************/



SET TERM ^ ;



/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/



/* Trigger: CENTRAL_SERVICOS_NOTIF_CODIGO */
CREATE OR ALTER TRIGGER CENTRAL_SERVICOS_NOTIF_CODIGO FOR CENTRAL_SERVICOS_NOTIFICACOES
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF (NEW.CODIGO IS NULL) THEN
    NEW.CODIGO = GEN_ID(GEN_CENTRAL_SERVICOS_NOTIFIC_ID,1);
END
^

/* Trigger: CENTRAL_SERVICOS_NOTIF_DATA_INC */
CREATE OR ALTER TRIGGER CENTRAL_SERVICOS_NOTIF_DATA_INC FOR CENTRAL_SERVICOS_NOTIFICACOES
ACTIVE BEFORE INSERT POSITION 2
AS
BEGIN
  NEW.DATA_INC = CURRENT_TIMESTAMP;
END
^

/* Trigger: CENTRAL_SERVICOS_NOTIF_FINALIZA */
CREATE OR ALTER TRIGGER CENTRAL_SERVICOS_NOTIF_FINALIZA FOR CENTRAL_SERVICOS_NOTIFICACOES
ACTIVE BEFORE INSERT OR UPDATE POSITION 3
AS
DECLARE VARIABLE I_TEMP INTEGER;
BEGIN
  IF ((NEW.FINALIZADO IS NOT NULL) AND
      (OLD.FINALIZADO IS DISTINCT FROM NEW.FINALIZADO)) THEN
  BEGIN
    SELECT COD_USUARIO
    FROM FUNCAO_COD_USUARIO
    INTO :I_TEMP;

    NEW.COD_USUARIO_FINALIZADO = :I_TEMP;
  END
END
^

/* Trigger: CENTRAL_SERVICOS_NOTIF_USUARIO */
CREATE OR ALTER TRIGGER CENTRAL_SERVICOS_NOTIF_USUARIO FOR CENTRAL_SERVICOS_NOTIFICACOES
ACTIVE BEFORE INSERT POSITION 1
AS
DECLARE VARIABLE I_TEMP INTEGER;
BEGIN
  SELECT COD_USUARIO
  FROM FUNCAO_COD_USUARIO
  INTO :I_TEMP;
  NEW.COD_USUARIO = :I_TEMP;
END
^
SET TERM ; ^